/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.client.music.loadertypes;

import dev.felnull.imp.client.music.loader.LavaPlayerMusicLoader;
import dev.felnull.imp.client.music.loadertypes.IMusicLoaderType;
import dev.felnull.imp.client.music.loadertypes.MusicLoadResult;
import dev.felnull.imp.client.util.LavaPlayerUtil;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.player.AudioPlayerManager;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import dev.felnull.imp.music.resource.ImageInfo;
import dev.felnull.imp.music.resource.MusicSource;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;

public abstract class AbstractLavaPlayerMusicLoaderType
implements IMusicLoaderType {
    private static final class_2561 ENTER_TEXT = new class_2588("imp.text.enterText.default");
    private final String rawName;
    private final class_2561 name;
    private final class_2960 icon;
    private final AudioPlayerManager audioPlayerManager;

    public AbstractLavaPlayerMusicLoaderType(String name) {
        this.rawName = name;
        this.name = new class_2588("imp.loaderType." + name);
        this.icon = new class_2960("iammusicplayer", "textures/gui/container/music_manager/loader_types/" + name + ".png");
        this.audioPlayerManager = LavaPlayerUtil.createAudioPlayerManager();
        this.audioPlayerManager.getConfiguration().setOutputFormat(LavaPlayerMusicLoader.COMMON_PCM_S16_LE_C2);
        this.registerSourceManager(this.audioPlayerManager);
    }

    @Override
    public class_2561 getName() {
        return this.name;
    }

    @Override
    public class_2960 getIcon() {
        return this.icon;
    }

    public AudioPlayerManager getAudioPlayerManager() {
        return this.audioPlayerManager;
    }

    public abstract void registerSourceManager(AudioPlayerManager var1);

    @Override
    public MusicLoadResult load(String sourceName) throws InterruptedException {
        try {
            Optional<AudioTrack> otrack = LavaPlayerUtil.loadTrack(this.getAudioPlayerManager(), sourceName);
            if (otrack.isPresent() && !otrack.get().getInfo().isStream) {
                return this.createResult(otrack.get());
            }
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        return null;
    }

    public MusicLoadResult createResult(AudioTrack track) {
        MusicSource ms = new MusicSource(this.rawName, this.getIdentifier(track), track.getDuration());
        return new MusicLoadResult(ms, this.createThumbnail(track), track.getInfo().title, track.getInfo().author);
    }

    protected ImageInfo createThumbnail(AudioTrack track) {
        return null;
    }

    public abstract boolean match(AudioTrack var1);

    public String getIdentifier(AudioTrack track) {
        return track.getIdentifier();
    }

    public String getRawName() {
        return this.rawName;
    }

    @Override
    public class_2561 getEnterText() {
        return ENTER_TEXT;
    }
}

